/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KickJump {
    static final TargetingConditions tc = new TargetingConditions(false).m_148355_().m_26893_();
    public static final ResourceLocation ADVANCEMENT_KICK_JUMP = new ResourceLocation("slashblade", "abilities/kick_jump");
    public static final String KEY_KICKJUMP = "sb.kickjump";

    public static KickJump getInstance() {
        return SingletonHolder.instance;
    }

    private KickJump() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        ServerPlayer sender = event.getEntity();
        Level worldIn = sender.m_9236_();
        if (sender.m_20096_()) {
            return;
        }
        if (old.contains((Object)InputCommand.JUMP)) {
            return;
        }
        if (!current.contains((Object)InputCommand.JUMP)) {
            return;
        }
        if (0 != sender.getPersistentData().m_128451_(KEY_KICKJUMP)) {
            return;
        }
        Iterable list = worldIn.m_186434_((Entity)sender, sender.m_20191_().m_82377_(0.5, 0.0, 1.0));
        if (!list.iterator().hasNext()) {
            return;
        }
        Untouchable.setUntouchable((LivingEntity)sender, 10);
        sender.getPersistentData().m_128405_(KEY_KICKJUMP, 2);
        Vec3 delta = sender.m_20184_();
        Vec3 motion = new Vec3(delta.f_82479_, 0.8, delta.f_82481_);
        sender.m_6478_(MoverType.SELF, motion);
        sender.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(sender.m_19879_(), motion.m_82490_(0.75)));
        AdvancementHelper.grantCriterion(sender, ADVANCEMENT_KICK_JUMP);
        sender.m_6330_(SoundEvents.f_12276_, SoundSource.PLAYERS, 0.5f, 1.2f);
        sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> s.updateComboSeq((LivingEntity)sender, ComboState.NONE));
        if (worldIn instanceof ServerLevel) {
            ((ServerLevel)worldIn).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50058_.m_49966_()), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), 20, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        switch (event.phase) {
            case START: {
                Player player = event.player;
                if (!event.player.m_20096_() || 0 >= event.player.getPersistentData().m_128451_(KEY_KICKJUMP)) break;
                int count = event.player.getPersistentData().m_128451_(KEY_KICKJUMP);
                if (--count <= 0) {
                    event.player.getPersistentData().m_128473_(KEY_KICKJUMP);
                    break;
                }
                event.player.getPersistentData().m_128405_(KEY_KICKJUMP, count);
            }
        }
    }

    private static final class SingletonHolder {
        private static final KickJump instance = new KickJump();

        private SingletonHolder() {
        }
    }
}

